///////////////////////////////////////////////
//
//	Runs any of the client tests 
//	in loops and with concurrent threads.
//
import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.BeanIface.*;
import java.util.*;
import java.io.*;

class TestThread extends Thread
{
	static final int NO_MGR			= 0;
	static final int ACCT_MGR 		= 1;
	static final int ADMIN_MGR 		= 2;	//	Not used (not implemented)
	static final int CLUSTER_MGR 	= 3;	//	Not used for stress testing
	static final int RATING_MGR 	= 4;
	static final int REC_MGR 		= 5;	
	static final int SEARCH_MGR 	= 6;


	static final int NO_TEST		= 0;
	static final int SNAME_TEST		= 1;
	static final int ACCTINFO_TEST	= 2;
	static final int VALIDATE_TEST	= 3;
	static final int GETPROD_TEST	= 4;
	static final int RATEPROD_TEST  = 5;

	static int 	mgrID 	= NO_MGR;
	static int 	testID 	= NO_TEST;
	static long testUID = 0;
	static String testEmail = "";
	static String testPwd	= "";
	static int numProd = 0;
	static int numLoops = 0;

	int threadID;

	public TestThread(String name, int id)
	{
		super(name);
		threadID = id;
	}
	
	public void testAcctMgr() 
	{
		AMTest mgr = new AMTest();
		for (int idx =0; idx < numLoops; idx ++) {
			System.out.println(getName() + " loop " + idx);
			switch(testID) {
				
				case SNAME_TEST:
					mgr.getScreenName(testUID);
				break;

				case ACCTINFO_TEST:
					mgr.getAcctInfo(testUID);
				break;
				
				case VALIDATE_TEST:
					mgr.validateUser(testEmail, testPwd);
				break;

				default:
				break;
			}
		}
	}

	public void testRatMgr()
	{
		RMTest ratMgrTester = new RMTest();
		for (int idx =0; idx < numLoops; idx ++) {
			System.out.println(getName() + " loop " + idx);
			switch(testID) {
				case GETPROD_TEST:
					ratMgrTester.getProducts(testUID, numProd);
					break;
				case RATEPROD_TEST:
					ratMgrTester.rateProducts(testUID, numProd);
					break;
				default:
				break;
			}
		}
	}

	public void testRecMgr()
	{
		//	This test uses a different user ID for each 
		long uidToUse = testUID + threadID;
		IRecommendationManagerBean rmb = null;
		try {
			rmb = BeanUtil.getRecMgr();
			for (int idx = 0; idx < numLoops; idx ++) {
				System.out.println(getName() + " loop " + idx);
				RecommendationList recList = rmb.getRecommendations(new SystemUser(uidToUse), numProd);
				StringBuffer outMsg = new StringBuffer("Recommended products: ");
				for (int recIdx = recList.size(); --recIdx> -1; ) {
					outMsg.append(recList.get(recIdx).prod.id);
					outMsg.append(" ");
				}
				System.out.println(outMsg);
				
			}
			rmb.remove();
		}
		catch (Exception e) {
			System.out.println("Exception in testRecMgr(): " + e.toString());
			e.printStackTrace();
			return;
		}
				
	}
	
	public void run() 
	{
		switch(mgrID) {
			case NO_MGR:
			break;

			case ACCT_MGR:
				testAcctMgr();
				break;

			case RATING_MGR:
				testRatMgr();
				break;
			case REC_MGR:
				testRecMgr();
				break;
			

			default:
			break;
		}
					
		System.out.println(getName() + " ending.");
	}
	

}

class ClientTest 
{
	static final String README_FILE = "ClientTest.readme";
	static final String MGR_ARGNAME = "-mgr";
	static final String TEST_ARGNAME = "-test";

	static final String SNAME_TEST_ARG = "sname";
	static final String VALIDATE_TEST_ARG = "valid";
	static final String ACCTINFO_TEST_ARG = "info";
	static final String GETPROD_TEST_ARG = "getprod";
	static final String RATEPROD_TEST_ARG = "rateprod";
	
	static final String THREAD_NAME_PREFIX="TestThread";

	static int numThreads = 1;
	

	//	Constructor: instantiation will run the tests
	//
	public ClientTest()
	{
		TestThread[] testers = new TestThread[this.numThreads];
		for (int idx=0; idx<this.numThreads;idx++) {
			testers[idx] = new TestThread(THREAD_NAME_PREFIX + ' ' + idx, idx);
			testers[idx].start();
		}
	}

	public static void error(String errstr) 
	{
		System.err.println("Error: " + errstr);
		System.exit(1);
	}
	//	Outputs the usage from the README file
	//
	public static void usage()
	{
		try {
			FileReader f = new FileReader(README_FILE);
			final int BUFSIZE=0xFF;
			char buf[] = new char[BUFSIZE];
			int BytesRead;
			while (true) {
				BytesRead = f.read(buf, 0, BUFSIZE);
				if (BytesRead < 1)
					break;
				System.out.print(new String(buf, 0, BytesRead));
			}
		}
		catch(Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
				
		System.exit(1);
	}

	//	Determines the number of loops to use
	//
	public static int getLoops(String[] args) throws NumberFormatException
	{
		int numLoops = 1;
		for (int idx = args.length-1; --idx > -1; ){
			if (args[idx].compareTo("-loops") == 0 ) {
				numLoops = Integer.parseInt(args[idx + 1]);
				break;
			}
		}
		return numLoops;
	}

	//	Determines the number of threads to use
	//
	public static int getThreads(String[] args) throws NumberFormatException
	{
		int numThreads = 1;
		for (int idx = args.length -1; --idx > -1; ) {
			if (args[idx].compareTo("-threads") == 0) {
				numThreads = Integer.parseInt(args[idx+1]);
				break;
			}
		}
		return numThreads;
	}

	//	Determines which manager to test.
	//
	public static int getMgr(String[] args) 
	{
		//	Make a hashtable mapping the string argument to the
		//	Long representation of its numeric ID
		//
		Hashtable mgrArgHash = new Hashtable();
		mgrArgHash.put("acctmgr", new Integer(TestThread.ACCT_MGR));
		mgrArgHash.put("ratmgr", new Integer(TestThread.RATING_MGR));
		mgrArgHash.put("recmgr", new Integer(TestThread.REC_MGR));
		mgrArgHash.put("searchmgr", new Integer(TestThread.SEARCH_MGR));
		
		int mgrID = TestThread.NO_MGR;
		//	Find the MGR_ARGNAME argument
		//
		for (int idx=0; idx<(args.length - 1);idx++) {
			if (args[idx].compareTo(MGR_ARGNAME) == 0) {
				String mgr = args[idx+1];
				//	Get the Long mapped to the string following the 
				//	-mgr argument
				//
				Integer mgrInt = (Integer)mgrArgHash.get(mgr);
				if (mgrInt != null) {
					mgrID= mgrInt.intValue();
				}
				break;
			}
		}
		return mgrID;
	}

	//	Finds the argument index just after the TEST_ARGNAME argument.
	//
	public static int getTestArgsIdx(String[] args) 
	{
		for (int idx = args.length - 1; --idx > -1; ) {
			if (args[idx].compareTo(TEST_ARGNAME) == 0) {
				return idx + 1;
			}
		}
		return -1;
	}

	//	Gets the user id from the argument string at the given index,
	//	or print the appropriate error.
	//
	public static long getUID(String[] args, int idx) throws NumberFormatException
	{
		if (idx >= args.length) {
			error("You must supply a UID with this test.");
		}
		return Long.parseLong(args[idx]);
	}
	
	public static void main (String[] args) 
	{
		if (args.length < 1)
			usage();
		
		numThreads = getThreads(args);
		//	Set static vars in TestThread class
		//
		TestThread.numLoops = getLoops(args);
		TestThread.mgrID = getMgr(args);
		System.out.println("loops: " + TestThread.numLoops);
		System.out.println("threads: " + numThreads);
		System.out.println("mgrID: " + TestThread.mgrID);
		int testArgIdx = getTestArgsIdx(args);
		
		switch(TestThread.mgrID) {

			//	Account Manager
			//
			case TestThread.ACCT_MGR:
			
				// Parse the the test arguments
				//
				if (testArgIdx == -1) {
					error("You must supply a test to use with the AccountManager.");
				}
				if (args[testArgIdx].compareTo(SNAME_TEST_ARG) == 0) {
					TestThread.testID = TestThread.SNAME_TEST;
					TestThread.testUID = getUID(args, testArgIdx + 1);
				}
				else if (args[testArgIdx].compareTo(ACCTINFO_TEST_ARG) == 0) {
					TestThread.testID = TestThread.ACCTINFO_TEST;
					TestThread.testUID = getUID(args,testArgIdx + 1);
				}
				else if (args[testArgIdx].compareTo(VALIDATE_TEST_ARG) == 0) {
					TestThread.testID = TestThread.VALIDATE_TEST;
					if (testArgIdx + 2 >= args.length) {
						error("You must supply both validation parameters with this test.");
					}
					TestThread.testEmail = args[testArgIdx+1];
					TestThread.testPwd = args[testArgIdx+2];
				}
				else {
					error("Please specify a test to use with AccountManager.");
				}
				break;


			//	Rating Manager
			//
			case TestThread.RATING_MGR:
				//	check the # of test arguments
				//
				if (testArgIdx == -1) 
					error("You must supply a test to use with the Rating Manager");
				if (testArgIdx + 2 >= args.length) 
					error("You must supply both the user ID and the number of products to get or rate.");
				//	Assign the test
				//
				if (args[testArgIdx].compareTo(GETPROD_TEST_ARG) == 0) 
					TestThread.testID = TestThread.GETPROD_TEST;
				if (args[testArgIdx].compareTo(RATEPROD_TEST_ARG) == 0) 
					TestThread.testID = TestThread.RATEPROD_TEST;
				//	Parse the UID and number of products to get/rate
				//
				TestThread.testUID = getUID(args, testArgIdx+1);
				TestThread.numProd = Integer.parseInt(args[testArgIdx+2]);
					
				
				break;

			case TestThread.REC_MGR:
				//	check the # of test arguments
				//
				if (testArgIdx == -1) 
					error("You must supply a test to use with the Recommendation Manager");
				if (testArgIdx + 1 >= args.length) 
					error("You must supply both the user ID and the number of products to get or rate.");
				//	Parse the UID and number of products to get/rate
				//
				TestThread.testUID = getUID(args, testArgIdx);
				TestThread.numProd = Integer.parseInt(args[testArgIdx+1]);
				break;

			case TestThread.NO_MGR:
			default:
				error("You must specify a manager to test.");
				break;
		
		}
		ClientTest This = new ClientTest();
	}


}
